"""Login page for the Streamlit application."""

import streamlit as st
from services.auth_service import AuthService  # note: local import

def render(auth_service: AuthService) -> None:
    st.title("Welcome to CA Office Task Management Application")
    st.write("Please enter your credentials to continue.")

    with st.form("login_form"):
        username = st.text_input("Username")
        password = st.text_input("Password", type="password")
        submitted = st.form_submit_button("Login")

    if submitted:
        ok, user = auth_service.login(username, password)
        if ok and user:
            # Persist session details
            st.session_state.logged_in = True
            st.session_state.username = user.get("username")
            st.session_state.role = user.get("role")
            st.session_state.user_id = user.get("id")

            st.success("Login successful.")
            # Modern API (replaces deprecated st.experimental_rerun)
            st.rerun()
        else:
            st.error("Invalid username or password.")
